%define module_name App-RewriteVersion
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Tiny/Chained.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long/Modern.pm) perl(Module/Build.pm) perl(Module/Build/Tiny.pm) perl(Module/Metadata.pm) perl(Path/Iterator/Rule.pm) perl(Path/Tiny.pm) perl(Test/More.pm) perl(Version/Next.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.000
Release: alt1
Summary: A tool to rewrite and bump your Perl module versions
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/App-RewriteVersion

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the App::RewriteVersion manpage is a tool for managing Perl module versions in a
distribution. It is heavily based on the the Dist::Zilla manpage plugin
the Dist::Zilla::Plugin::RewriteVersion manpage. Similarly to that plugin, the `V'
environment variable can be used to override the version detected from the main
module.

Existing version assignments and new versions must be parseable with the same
rules as in the section on "DESCRIPTION" in the Dist::Zilla::Plugin::RewriteVersion manpage, that is to
say, they should either be a decimal number with a single decimal point, or a
tuple version with a leading `v' and at least 3 segments separated by decimal
points. Version assignments should be in the form `our $VERSION = '...';'.

See the perl-rewrite-version manpage and the perl-bump-version manpage for details on
command-line usage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes CONTRIBUTING.md README LICENSE
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
