# BEGIN SourceDeps(oneline):
BuildRequires: perl(Acme/Zalgo.pm) perl(AnyEvent.pm) perl(AnyEvent/IRC/Client.pm) perl(AnyEvent/Mattermost.pm) perl(AnyEvent/SlackRTM.pm) perl(App/Sqitch.pm) perl(Clone.pm) perl(Config/Any/Merge.pm) perl(Config/General.pm) perl(DBD/Pg.pm) perl(DBIx/DataStore.pm) perl(Data/Dumper.pm) perl(DateTime.pm) perl(DateTime/Format/Pg.pm) perl(EV.pm) perl(Exporter/Easy.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(Getopt/Long/Descriptive.pm) perl(HTML/TreeBuilder/LibXML.pm) perl(HTML/TreeBuilder/XPath.pm) perl(HTTP/Request.pm) perl(IPC/Open2.pm) perl(JSON.pm) perl(JSON/Path.pm) perl(LWP/Protocol/https.pm) perl(LWP/Simple.pm) perl(LWP/UserAgent.pm) perl(Lingua/EN/Tagger.pm) perl(List/Util.pm) perl(Log/Dispatch/Screen.pm)
BuildRequires: perl(Log/Log4perl.pm) perl(Log/Log4perl/Appender/Screen.pm) perl(Module/Loaded.pm) perl(Module/Pluggable/Object.pm) perl(Moose.pm) perl(MooseX/ClassAttribute.pm) perl(MooseX/SetOnce.pm) perl(Number/Format.pm) perl(Pod/Simple/SimpleTree.pm) perl(Scalar/Util.pm) perl(Term/ExtendedColor.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Text/Aspell.pm) perl(Text/Levenshtein.pm) perl(Text/Wrap.pm) perl(Time/HiRes.pm) perl(Try/Tiny.pm) perl(URI.pm) perl(URI/Find.pm) perl(URI/QueryParam.pm) perl(XML/LibXML.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name App-RoboBot
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.004
Release: alt1
Summary: Extensible multi-protocol S-Expression chatbot.
Group: Development/Perl
License: perl
URL: https://github.com/jsime/robobot

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JS/JSIME/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
App::RoboBot provides an event-driven, multi-protocol, multi-network,
user-programmable, plugin-based, S-Expression chatbot. Any text-based chat
service could be supported, with plugins currently for IRC, Slack, and
Mattermost included.

Major features include:

=over 4

=item * S-Expression Syntax

Chatbot commands are issued via an S-Expression syntax (spiritual guidance from
Clojure on some of the sugar for non-list structures). This language, while no
match for a full-blown, general purpose programming environment, is flexible
enough when combined with the macro and plugin support to allow users on your
chat service of choice to dynamically extend the functionality of the bot on
the fly.

=item * Multi-protocol

App::RoboBot currently includes support for IRC, Slack, and Mattermost out of
the box. Additional service plugins would be easy to add, as long as there is
an AnyEvent compatible library for them on CPAN or you are willing to write
one. Network protocol plugins need only implement a small number of methods
for core actions like connection/disconnecting from a network service, parsing
incoming messages, and sending messages.

=item * Multi-network

Bot instances created with App::RoboBot may connect to multiple networks
simultaneously (critical for some plugins like ChannelLink which let you create
your own bridges between disparate networks), even across different protocols.
The only practical limits are memory and bandwidth for the host running your
bot.

=item * Macros

User-defined macros are core to App::RoboBot's operation and allow authorized
users on your chat services to define new functionality for the bot on the fly
using a Lisp-like (emphasis on the "like") language. Macros can invoke
functions, other macros, and even create more macros. Macros use the exact same
S-Expression language as everything else in the bot, and have access to the
full functionality.

=item * Plugins

Nearly all App::RoboBot functionality is provided through the plugin system.
The distribution ships with many...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README Changes doc
%_bindir/*
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*

%changelog
