# BEGIN SourceDeps(oneline):
BuildRequires: perl(English.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(LWP/UserAgent.pm) perl(Mojo/UserAgent.pm) perl(POSIX.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Strict.pm) perl(Text/Template.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_version 3.0.5
%define module_name App-Slaughter
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.0.5
Release: alt1
Summary: The Slaughter System Administration Utility.
Group: Development/Perl
License: perl
URL: https://github.com/skx/slaughter/

Source0: http://cpan.org.ua/authors/id/S/SK/SKX/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is the platform-independant library which is used to abstract
the implementations of the Slaughter primitives.

It is loaded via:

=for example begin

   use Slaughter;

=for example end

This usage actually dynamically loads the appropriate module from beneath the
Slaughter::API namespace - which will contain the primitive implementation.

Initially we load the the Slaughter::API::generic manpage module which contains pure-perl
implemenation, and then we load the OS-specific module from the supported set:

=over 8

=item the Slaughter::API::linux manpage

The implemetnation of our primitive API for GNU/Linux.

=item the Slaughter::API::freebsd manpage

The implemetnation of our primitive API for FreeBSD.

=back

Assuming that the OS-specific module is successfully loaded we we will also
load any *local* OS-specific module.  (e.g. `Slaughter::API::Local::linux'.)

Fallback implementations in our generic module merely output a suitable
error message:

=for example begin

  This module is not implemented for $^O

=for example end

This allows compiled policies to execute, without throwing errors, and also
report upon the primitives which need to be implemented or adapted.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE examples/basic/README AUTHORS README.md ChangeLog examples
%perl_vendor_privlib/S*
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
