# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/ShareDir.pm) perl(File/ShareDir/Install.pm) perl(File/Temp.pm) perl(File/stat.pm) perl(FindBin.pm) perl(Getopt/Long.pm) perl(Linux/Inotify2.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Adapter/Daemontools.pm) perl(Log/Any/Adapter/TAP.pm) perl(Mojo/Base.pm) perl(Mojo/DOM.pm) perl(Mojo/File.pm) perl(Mojo/Log.pm) perl(Mojo/WebSocket.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Test/Mojo.pm) perl(Test/More.pm) perl(Text/Markdown/Hoedown.pm) perl(utf8.pm)
# END SourceDeps(oneline)
%define module_name App-SlideServer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Serves a HTML slide show synchronized over WebSocket
Group: Development/Perl
License: perl
URL: https://github.com/nrdvana/perl-App-SlideServer

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class is a fairly simple Mojo web application that serves a small
directory of files, one of which is a Markdown or HTML document containing
your slides.  The slides then use the provided JavaScript to create a
presentation similar to other popular software, and a user interface for
the presenter.  As a bonus, you can make any number of connections to the
server and synchronize the slide show over a websocket, allowing viewers
to follow the presenter, or the presenter to flip slides from a different
device than is connected to the projector (like a tablet or phone).

On startup, the application upgrades your slides to a proper HTML structure
(see the HTML SPECIFICATION entry elsewhere in this document) possibly by first running it through a Markdown
renderer if you provided the slides as markdown instead of HTML.  It then
inspects the HTML and breaks it apart into one or more slides.

You may then start the Mojo application as a webserver, or whatever else you
wanted to do with the Mojo API.

The application comes with a collection of web assets that render your HTML
to fit fullscreen in a browser window, and to provide a user interface to the
presenter that shows navigation buttons and private notes for giving the
presentation.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE example
%_bindir/*
%_man1dir/*
%perl_vendor_privlib/A*
%perl_vendor_privlib/auto/*

%changelog
