%def_without test
%define module_name App-Staticperl
%add_findreq_skiplist %_bindir/*
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/curl /usr/bin/wget perl(ExtUtils/MakeMaker.pm) perl(PPI.pm) perl(Pod/Strip.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.46
Release: alt1
Summary: perl, libc, 100 modules, all in one standalone 500kb file
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This script helps you to create single-file perl interpreters
or applications, or embedding a perl interpreter in your
applications. Single-file means that it is fully self-contained - no
separate shared objects, no autoload fragments, no .pm or .pl files are
needed. And when linking statically, you can create (or embed) a single
file that contains perl interpreter, libc, all the modules you need, all
the libraries you need and of course your actual program.

With uClibc and upx on x86, you can create a single 500kb binary
that contains perl and 100 modules such as POSIX, AnyEvent, EV, IO::AIO,
Coro and so on. Or any other choice of modules (and some other size :).

To see how this turns out, you can try out smallperl and bigperl, two
pre-built static and compressed perl binaries with many and even more
modules: just follow the links at http://staticperl.schmorp.de/.

The created files do not need write access to the file system (like PAR
does). In fact, since this script is in many ways similar to PAR::Packer,
here are the differences:

=over 4

=item * The generated executables are much smaller than PAR created ones.

Shared objects and the perl binary contain a lot of extra info, while
the static nature of staticperl allows the linker to remove all
functionality and meta-info not required by the final executable. Even
extensions statically compiled into perl at build time will only be
present in the final executable when needed.

In addition, staticperl can strip perl sources much more effectively
than PAR.

=item * The generated executables start much faster.

There is no need to unpack files, or even to parse Zip archives (which is
slow and memory-consuming business).

=item * The generated executables don't need a writable filesystem.

staticperl loads all required files directly from memory. There is no
need to unpack files into a temporary directory.

=item * More control over included files, more burden.

PAR tries to be maintenance and hassle-free - it tries to include more
files than necessary to make sure everything works out of the box. It
mostly succeeds at this, but he extra files (such as the unicode database)
can take substantial amounts of memory and file size.

With staticperl, the burden is mostly with the developer - only direct
compile-time dependencies and the AutoLoader manpage are handled automatically.
This means the modules to include often need to be tweaked manually.

All this does not preclude more permissive modes to be implemented in
the future, but right now, you have to resolve hidden dependencies
manually.

=item * PAR works out of the box, staticperl does not.

Maintaining your own custom perl build can be a pain in the ass, and while
staticperl tries to make this easy, it still requires a custom perl
build and possibly fiddling with some modules. PAR is likely to produce
results faster.

Ok, PAR never has worked for me out of the box, and for some people,
staticperl does work out of the box, as they don't count "fiddling with
module use lists" against it, but nevertheless, staticperl is certainly
a bit more difficult to use.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc COPYING README Changes
%_man1dir/*

%files scripts
%_bindir/*

%changelog
