%define module_name App-Toodledo
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Date/Parse.pm) perl(Digest/MD5.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(JSON.pm) perl(LWP/UserAgent.pm) perl(Log/Log4perl.pm) perl(Moose.pm) perl(MooseX/ClassAttribute.pm) perl(MooseX/Log/Log4perl.pm) perl(MooseX/Method/Signatures.pm) perl(Package/Stash.pm) perl(Parse/Method/Signatures.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(Test/NoWarnings.pm) perl(URI/Encode.pm) perl(YAML.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.19
Release: alt1
Summary: Interacting with the Toodledo task management service.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PJ/PJS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Toodledo (http://www.toodledo.com/) is a web-based capability for managing
to-do lists along Getting Things Done (GTD) lines.  This module
provides a Perl-based access to its API.

This version is a minimal port to version 2 of the Toodledo API.
It is not at all backwards compatible with version 0.07 or earlier of this
module.
Toodledo now frowns upon using version 1 of the API; not using an
application token makes it almost impossible to get anything useful
done.

What do you need the API for?  Doesn't the web interface do everything
you want?  Not always.  See the examples included with this distribution.
For instance, Toodledo has only one level of notification and it's either
on or off.  With the API you can customize the heck out of notification.
Or suppose you want to find tasks where the due date has erroneously
been set to before the start date.  Toodledo lets you do this and the
online search function can't find them.  But with `App::Toodledo' it's
as simple as:

  say $_->title for $todo->select( \@tasks => q{duedate && startdate > duedate} )

This is a very basic, preliminary Toodledo module.  I wrote it to do the
few things I wanted out of an API and when I feel a need for some
additional capability, I'll add it.  In the mean time, if there's something
you want it to do, feel free to submit a patch.  Or, heck, if you're
sufficiently motivated, I'll let you take over the whole thing.

This module uses the MooseX::Method::Signatures manpage to perform argument validation.
If you violate the type checking you will quite probably get upwards of a
hundred lines of error messages.  That's the way it goes.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes examples
%perl_vendor_privlib/A*

%changelog
