# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    App-Trace
%define upstream_version 0.50

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_11

Summary:    Embedded debug statements, including call/return tracing
License:    GPLv1+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/App/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(App/Options.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch: noarch
Source44: import.info

%description
App::Trace provides debug/tracing support for perl programs and modules.

The basic concept is that you put a special call at the beginning and end
of each subroutine/method, and when tracing is enabled, you can see the
flow of your program.

This module reflects my dislike of the perl debugger. I also dislike
putting in print statements to debug, then commenting them out when I'm
done. I would rather put debug statements in my code and leave them there.
That way, when programs work their way into production, they can still be
debugged by using appropriate command line options.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc TODO README META.yml CHANGES
%perl_vendor_privlib/*




%changelog
