# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(Glib.pm) perl(Gtk2.pm) perl(Gtk2/SimpleMenu.pm) perl(IO/Handle.pm) perl(Moose.pm) perl(Net/DBus.pm) perl(Net/DBus/Dumper.pm) perl(Net/DBus/GLib.pm) perl(Pod/Usage.pm) perl(Test/More.pm) xvfb-run
# END SourceDeps(oneline)
%ifndef _build_display
%def_without test
%endif
%define module_version 1.02
%define module_name App-USBKeyCopyCon
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.02
Release: alt1
Summary: GUI console for bulk copying of USB keys
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/G/GR/GRANTM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module implements an application for bulk copying USB flash drives
(storage devices).  The application was developed to run on Linux and is
probably not particularly portable to other platforms.

From a user's perspective the operation is simple:

=over 4

=item 1

insert a 'master' USB key when prompted - the contents of the key will be
copied into a temporary directory on the hard drive, after which the key can be
removed

=item 2

insert blank keys into all available USB ports - the app will detect when each
new key is inserted, start the copy process and alert the user on completion

=item 3

repeat step 2 as required

=back

The program can write to multiple keys in parallel.  It can also use filtering
on device parameters to only overwrite devices which match the vendor name
and storage capacity specified - other devices will be ignored.

The specifics of reading the master key, preparing a blank key (formatting
parameters etc) are implemented in short 'profile' scripts (a reader and a
writer).  You can supply your own profile scripts if your requirements differ
from those provided.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir
xvfb-run -a make test

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
