%define module_name App-Unliner
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest/SHA1.pm) perl(ExtUtils/MakeMaker.pm) perl(Getopt/Long.pm) perl(Pod/Perldoc.pm) perl(Regexp/Grammars.pm) perl(Template.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.020
Release: alt2
Summary: Untangle your unix pipeline one-liners
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/F/FR/FRACTAL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Unliner is a scripting language and toolset for refactoring and developing unix one-liners.

Note: This page is a high-level overview of unliner. For an introduction and manual, see the App::Unliner::Intro manpage.

The simplest way to install unliner is with cpanminus:

    curl -sL https://raw.github.com/miyagawa/cpanminus/master/cpanm | sudo perl - App::Unliner

Here is an unliner script to display response code tallies from standard apache logs. Save it in the file `reportgen':

    #!/usr/bin/env unliner

    def main {
        extract-response-codes $@ | tally
    }

    def extract-response-codes : perl -n {
        ## HTTP response code is 2nd last field
        print "$1\n" if /(\d\d\d) \S+$/;
    }

    def tally {
        sort | uniq -c | sort -rn
    }

Now make `reportgen' executable:

    $ chmod a+x reportgen

Now you can run `reportgen' like a normal program:

    $ ./reportgen /var/www/log/access.log
      43628 200
       1911 301
        201 404
          6 500

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
