# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Path/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    App-XML-DocBook-Builder
%define upstream_version 0.1100

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Translate DocBook/XML to other formats
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/App/%{upstream_name}-%{upstream_version}.tar.gz

Provides:   docmake = %{version}-%{release}

BuildRequires: perl(Class/XSAccessor.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/ShouldUpdate.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Getopt/Long.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Trap.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(parent.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(vars.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
docmake is a tool to render DocBook/XML into its resultant formats using XSLT:
XHTML, XSL-FO, PDF, RTF, etc. For a brief help type docmake help .

It aims to be a replacement for xmlto.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%buildroot
# Fix the she-bang. See:
# https://wiki.mageia.org/en/Perl_policy#Executables
perl -i -lpe 's{^(#\!/usr/bin/perl).*}{$1} if $. == 1' %{buildroot}/%{_bindir}/*

%files
%doc COPYING Changes LICENSE META.json META.yml  README
%{_bindir}/docmake
%{_mandir}/man1/*
%perl_vendor_privlib/*

%changelog
