# BEGIN SourceDeps(oneline):
BuildRequires: perl(Browser/Open.pm) perl(Config/Tiny.pm) perl(File/Basename.pm) perl(FindBin.pm) perl(IPC/System/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(Text/Abbrev.pm) perl(Text/Wrap.pm) perl(URI/Encode.pm)
# END SourceDeps(oneline)
%define module_version 0.06
%define module_name App-lookup
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.06
Release: alt1
Summary: search the internet from your terminal
Group: Development/Perl
License: perl
URL: https://github.com/Syaltut/perl-App-lookup

Source0: http://cpan.org.ua/authors/id/S/SY/SYALTUT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is a simple command line program which lets you search the internet from.the terminal. It's not exactly the most original idea out there. I personally
have used various programs which pretty much do the same thing, (most of these
even offer better user interface): custom web search feature in Firefox,
similar feature in Quicksilver and
Launchy, a fairly sophisticated command line
program called googlecl, and an emacs
lisp library called webjump.

But this raises quiet a few problems, namely:

=over

=item * The inability to share my own custom sites defined in one program with
another.

=item * Some programs are tied to a specific platform, e.g. Quicksilver on
OSX, Launchy on Windows, and webjump on emacs :p. See also: problem #1.

=back

This program offers a simple solution to said problems. It uses a plain text
file configuration which you can use to add your own custom sites (and
aliases, but more on that later). You can also use it to interface with other
programs, see the section the INTEGRATION WITH EMACS entry elsewhere in this document for an example.

By default you're only able to search with google. You can search with more
sites by putting the following in the file ~/.lookuprc (see
the CONFIGURATION FILE entry elsewhere in this document).

  [sites]
  bing = http://www.bing.com/search?q=%%(query)

Assuming that's the only thing you put in the config file (to make sure that
the abbreviations don't clash), you'll be able to search with
bing with either one of the following commands:

  lookup bing foobar
  lookup bin foobar
  lookup bi foobar
  lookup b foobar

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %{?epoch:%epoch:}%name = %version-%release

%description scripts
scripts for %module_name


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build --install_path bindoc=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
