# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/optex.pm) perl(File/Basename.pm) perl(Getopt/EX/Config.pm) perl(Getopt/Long.pm) perl(Hash/Util.pm) perl(List/Util.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm) perl(Text/Glob.pm)
# END SourceDeps(oneline)
%define module_name App-optex-glob
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: optex filter to glob filenames
Group: Development/Perl
License: perl
URL: https://github.com/kaz-utashiro/optex-glob

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/U/UT/UTASHIRO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is used to select filenames given as arguments by pattern.

For example, the following will pass only files matching `*.c' from
`*/*' as arguments to `ls'.

    optex -Mglob '*.c' -- ls -l */*

Only existing file names will be selected.  Any arguments that do not
correspond to files will be passed through as is.  In this example,
the command name and options remain as they are because no
corresponding file exists.  Be aware that the existence of a
corresponding file for unexpected parameter could lead to confusing
results.

There are several unique options that are valid only for this module.

=over 7

=item !*pattern*

=item --exclude *pattern*

Option `--exclude' will mean the opposite.

    optex -Mglob --exclude '*.c' -- ls */*

Preceding pattern with `!' will also exclude the pattern.

    optex -Mglob '!*.c' -- ls */*

If the `--exclude' option is used with positive patterns, the exclude
pattern takes precedence.  The following command selects files
matching `*.c', but excludes those begin with a capital letter.

    optex -Mglob --exclude '[A-Z]*' '*.c' -- ls */*

This opiton can be used multiple times.

=item --regex

If the `--regex' option is given, patterns are evaluated as a regular
expression instead of a glob pattern.

    optex -Mglob --regex '\.c$' -- ls */*

=item --path

With the `--path' option it matches against the entire path, not just
the filename.

    optex -Mglob --path '^*_test/' -- ls */*

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README.md
%perl_vendor_privlib/A*

%changelog
