%define module_name App-padconsole
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Browser/Open.pm) perl(Config/YAML.pm) perl(DateTime.pm) perl(Etherpad.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(IPC/Open3.pm) perl(Mojo/File.pm) perl(Mojo/Util.pm) perl(Term/ReadLine.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: A console to manage your etherpad instance
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LD/LDIDRY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides a console to manage an etherpad instance. Get infos about pads, delete them, etc.

       --help                      prints a help message and exit

       --version                   prints version and exit

       -e http://pad.example.com   URL of the etherpad instance

       -k secretPadApiKey          API key for the etherpad instance

       -u padUserLogin             username for the etherpad instance, if needed

       -p padUserPassword          password for the etherpad instance

       -c /path/to/config/file     use a different config file than \$XDG_HOME_DIR/padconsolerc or ~/.config/padconsolerc

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}
sed -i "s,'1\.2\.13\.1',0," Makefile.PL

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/A*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
