%define module_name App-plockf
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(IPC/Run.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: execute a command while holding a flock lock
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SR/SREZIC/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
plockf is a perl port of the FreeBSD utility the lockf(1) manpage.

The plockf utility acquires an exclusive lock on a *file*, creating
it if necessary, and removing the file on exit unless explicitly told
not to. While holding the lock, it executes a *command* with optional
*arguments*. After the *command* completes, plockf releases the
lock, and removes the *file* unless the `-k' option is specified.
BSD-style locking is used, as described in the flock(2) manpage; the mere
existence of the *file* is not considered to constitute a lock.

If the plockf utility is being used to facilitate concurrency
between a number of processes, it is recommended that the `-k' option
be used. This will guarantee lock ordering, as well as implement a
performance enhanced algorithm which minimizes CPU load associated
with concurrent unlink, drop and re-acquire activity. It should be
noted that if the `-k' option is not used, then no guarantees around
lock ordering can be made.

The following options are supported:

=over

=item `-k'

Causes the lock *file* to be kept (not removed) after the command
completes.

=item `-s'

Causes plockf to operate silently. Failure to acquire the lock is
indicated only in the exit status.

=item `-n'

Causes plockf to fail if the specified lock *file* does not exist.
If `-n' is not specified, plockf will create *file* if necessary.

=item `-t *seconds*'

Specifies a timeout for waiting for the lock. By default, plockf
waits indefinitely to acquire the lock. If a timeout is specified with
this option, plockf will wait at most the given number of *seconds*
before giving up. A timeout of 0 may be given, in which case plockf
will fail unless it can acquire the lock immediately. When a lock
times out, *command* is not executed.

Unlike the original the lockf manpage utility, the plockf manpage may handle also
floating point timeouts on systems which implement
`Time::HiRes::alarm'; on Windows systems only integer timeouts are
supported.

=back

In no event will plockf break a lock that is held by...
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
