%define module_name App-sslmaker
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/openssl perl(ExtUtils/MakeMaker.pm) perl(File/umask.pm) perl(Getopt/App.pm) perl(IO/Socket/IP.pm) perl(Path/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.21
Release: alt1
Summary: Be your own SSL certificate authority
Group: Development/Perl
License: artistic_2
URL: https://github.com/jhthorsen/app-sslmaker

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JH/JHTHORSEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
the App::sslmaker manpage is a module that provide methods for acting as your own
CA (certificate authority).
It can creating SSL keys, certificates and signing requests. The methods
should have good defaults and "just work", so you don't have to worry about
the details. "Just work" depends on safe defaults, which will change when
new and more secure standards come along.

The openssl commands are based on the instructions from
https://jamielinux.com/blog/category/CA/.

This module is used by the `sslmaker' command line application, but can also
act as a standalone toolkit.

From https://jamielinux.com/articles/2013/08/act-as-your-own-certificate-authority/:

  Most websites, such as shopping, banking or email websites, need to let their
  customers know that the connection is secure. Thus, they need to pay a
  well-known and internationally trusted CA (eg, VeriSign) to issue an SSL
  certificate. However, this isn't always necessary. For example, if you're
  setting up a virtual private network (VPN) or an intranet website, it might
  make more sense to issue your own certificates.

  Being a CA means dealing with cryptographic pairs of private keys and public
  certificates. Ideally the cryptographic pairs should be generated in a secure
  environment, which means a personal laptop or computer that is disconnected
  from the Internet. It is not recommended to generate any certificates
  directly on your server.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc Changes README.md
%perl_vendor_privlib/A*

%files scripts
%_bindir/*

%changelog
