%filter_from_requires /^perl.Local._pci_clean_json.pm./d
%filter_from_requires /^perl.Local._pci_check_args.pm./d
%define module_name App-td
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Sample/WeightedRandom.pm) perl(Cpanel/JSON/XS.pm) perl(Data/Check/Structure.pm) perl(Data/Sah/Compiler/perl/TH/array.pm) perl(Data/Sah/Compiler/perl/TH/bool.pm) perl(Data/Sah/Compiler/perl/TH/str.pm) perl(Data/TableData/Object/aoaos.pm) perl(Data/TableData/Object/aohos.pm) perl(Data/TableData/Object/aos.pm) perl(Data/TableData/Object/hash.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(List/MoreUtils.pm) perl(Perinci/CmdLine/Any.pm) perl(Perinci/CmdLine/Lite.pm) perl(PerlX/Maybe.pm) perl(Pipe/Find.pm) perl(Pod/Coverage/TrustPod.pm) perl(Sah/Schema/true.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Text/CSV_XS.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.112
Release: alt1
Summary: Manipulate table data
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/App-td

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*td* receives table data from standard input and performs an action on it. It
has functionality similar to some Unix commands like *head*, *tail*, *wc*,
*cut*, *sort* except that it operates on table rows/columns instead of
lines/characters. This is convenient to use with CLI scripts that output table
data.

A *table data* is JSON-encoded data in the form of either: `hos' (hash of
scalars, which is viewed as a two-column table where the columns are `key' and
`value'), `aos' (array of scalars, which is viewed as a 1-column array where the
column is `elem'), `aoaos' (array of arrays of scalars), or `aohos' (array of
hashes of scalars).

The input can also be an *enveloped* table data, where the envelope is an array:
`[status, message, content, meta]' and `content' is the actual table data. This
kind of data is produced by `Perinci::CmdLine'-based scripts and can contain
more detailed table specification in the `meta' hash, which `td' can parse.

First you might want to use the `info' action to see if the input is a table
data:

 %% osnames -l --json | td info

If input is not valid JSON, a JSON parse error will be displayed. If input is
valid JSON but not a table data, another error will be displayed. Otherwise,
information about the table will be displayed (form, number of columns, column
names, number of rows, and so on).

Next, you can use these actions:

 # count number of rows (equivalent to "wc -l" Unix command)
 %% osnames -l --json | td rowcount
 
 # append a row containing rowcount
 %% osnames -l --json | td rowcount-row
 
 # append a row containing column names
 %% lcpan related-mods Perinci::CmdLine | td colnames-row
 
 # count number of columns
 %% osnames -l --json | td colcount
 
 # select some columns
 %% osnames -l --json | td select value description
 
 # only show first 5 rows
 %% osnames -l --json | td head -n5
 
 # only show last 5 rows
 %% osnames -l --json | td tail -n5
 
 # sort by column(s) (add "-" prefix to for descending order)
 %% osnames -l --json | td sort value tags
 %% osnames -l --jso...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/A*
%_man1dir/*
%_bindir/*

%changelog
