%define module_name Archive-Ar-Libarchive
# BEGIN SourceDeps(oneline):
BuildRequires: libarchive-devel libsowing-devel perl(Alien/Base/Wrapper.pm) perl(Alien/Libarchive.pm) perl(Alien/Libarchive3.pm) perl(ExtUtils/MakeMaker.pm) perl(Math/Int64.pm) perl(Test/MockObject.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.09
Release: alt2
Summary: Interface for manipulating ar archives with libarchive
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Archive::Ar::Libarchive

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz

%description
This module is a XS alternative to the Archive::Ar manpage that uses libarchive 
to read and write ar BSD, GNU and common ar archives.

There is no standard for the ar format.  Most modern archives are based 
on a common format with two extension variants, BSD and GNU.  Other 
esoteric variants (such as AIX (small), AIX (big) and Coherent) vary 
significantly from the common format and are not supported.  Debian's 
package format (.deb files) use the common format.

The interface attempts to be identical (with a couple of minor 
extensions) to the Archive::Ar manpage and the documentation presented here is 
based on that module. The diagnostic messages issued on error mostly 
come directly from libarchive, so they will likely not match exactly 
what the Archive::Ar manpage would produce, but it should issue a warning under
similar  circumstances.

The main advantage of the Archive::Ar manpage over this module is that it is 
written in pure perl, and thus does not require a compiler or 
libarchive.  As an XS module using libarchive it may be faster.

You may notice that the API to the Archive::Ar::Libarchive manpage and
the Archive::Ar manpage is similar to the Archive::Tar manpage and this was done
intentionally to keep similarity between the Archive::* modules.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE author.yml Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
