%define module_name Archive-ByteBoozer2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(File/Touch.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt7
Summary: Perl interface to David Malmborg's `ByteBoozer 2.0', a data cruncher for Commodore files
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PA/PAWELKROL/%{module_name}-%{version}.tar.gz

%description
David Malmborg's `ByteBoozer 2.0' is a data cruncher for Commodore files written in C. `ByteBoozer 2.0' is very much the same as `ByteBoozer 1.0', but it generates smaller files and decrunches at about 2x the speed. An additional effort was put into keeping the encoder at about the same speed as before. Obviously it is incompatible with the version `1.0'.

In Perl the following operations are implemented via `Archive::ByteBoozer2' package:

=over

=item *
Compressing a file.

=item *
Compressing a file and making an executable with start address `$xxxx'.

=item *
Compressing a file and relocating data to hex address `$xxxx'.

=back

Compressed data is by default written into a file named with `.b2' suffix. Target file must not exist. If you want an executable, use `ecrunch'. If you want to decrunch yourself, use `crunch' or `rcrunch'. The decruncher should be called with `X' and `Y' registers loaded with a hi- and lo-byte address of the crunched file in a memory.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
