%define module_name Archive-Libarchive-XS
# BEGIN SourceDeps(oneline):
BuildRequires: libarchive-devel libsowing-devel perl(Alien/Base/Wrapper.pm) perl(Alien/Libarchive3.pm) perl(Capture/Tiny.pm) perl(Config.pm) perl(DynaLoader.pm) perl(Encode.pm) perl(Exporter/Tidy.pm) perl(ExtUtils/CChecker.pm) perl(FindBin.pm) perl(Math/Int64.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(Text/ParseWords.pm) perl(XSLoader.pm) perl(base.pm) perl(open.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0903
Release: alt3
Summary: Perl bindings to libarchive via XS
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Archive::Libarchive::XS

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz

%description
This module provides a functional interface to libarchive.  libarchive is a
C library that can read and write archives in a variety of formats and with a 
variety of compression filters, optimized in a stream oriented way.  A familiarity
with the libarchive documentation would be helpful, but may not be necessary
for simple tasks.  The documentation for this module is split into four separate
documents:

=over 4

=item the Archive::Libarchive::XS manpage

This document, contains an overview and some examples.

=item the Archive::Libarchive::XS::Callback manpage

Documents the callback interface, used for customizing input and output.

=item the Archive::Libarchive::XS::Constant manpage

Documents the constants provided by this module.

=item the Archive::Libarchive::XS::Function manpage

The function reference, includes a list of all functions provided by this module.

=back

If you are linking against an older version of libarchive, some functions
and constants may not be available.  You can use the `can' method to test if
a function or constant is available, for example:

 if(Archive::Libarchive::XS->can('archive_read_support_filter_grzip')
 {
   # grzip filter is available.
 }
 
 if(Archive::Libarchive::XS->can('ARCHIVE_OK'))
 {
   # ... although ARCHIVE_OK should always be available.
 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml CONTRIBUTING LICENSE Changes README example
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
