%define module_version 0.6
%define module_name Array-APX
BuildRequires: unzip
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/DeepUtils.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.6
Release: alt1
Summary: Array Programming eXtensions
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VA/VAXMAN/%{module_name}-%{module_version}.zip
BuildArch: noarch

%description
This module extends Perl-5 with some basic functionality commonly found in
array programming languages like APL, Lang5 etc. It is basically a wrapper
of Array::Deeputils and overloads quite some basic Perl operators in a way
that allows easy manipulation of nested data structures. These data 
structures are basically blessed n-dimensional arrays that can be handled
in a way similar to APL or Lang5.

A nice example is the computation of a list of prime numbers using an
archetypical APL solution. The basic idea is this: Create an outer product
of two vectors [2 3 4 ... ]. The resulting matrix does not contain any 
primes since every number is the product of at least two integers. Then
check for every number in the original vector [2 3 4 ... ] if it is a 
member of this matrix. If not, it must be a prime number. The set 
theoretic method 'in' returns a selection vector consisting of 0 and 1
values which can be used in a second step to select only the prime values
from the original vector. Using Array::APX this can be written in Perl 
like this:

    use strict;
    use warnings;
    use Array::APX qw(:all);

    my $f = sub { $_[0] * $_[1] }; # We need an outer product
    my $x;

    print $x->select(!($x = iota(199) + 2)->in($x |$f| $x));

How does this work? First a vector [2 3 4 ... 100] is created:

    $x = iota(99) + 2

This vector is then used to create an outer product (basically a multiplication
table without the 1-column/row:

    my $f = sub { $_[0] * $_[1] }; # We need an outer product
    ... $x |$f| $x ...

The |-operator is used here as the generalized outer-'product'-operator 
(if applied to two APX data structures it would act as the bitwise binary or) 
- it expects a 
function reference like $f in the example above. Thus it is possible to
create any outer 'products' - not necessarily based on multiplication only.
Using the vector stored in $x and this two dimensional matrix, the 
in-method is used to derive a boolean vector that contains a 1 at every 
place corresponding to an element on the left hand operand that is contained
in the right hand operand. This boolean vector is then inverted using the
overloaded !-operator:

  !($x = iota(99) + 2)->in($x |$f| $x)

Using the select-method this boolean vector is used to select the elements
corresponding to places marked with 1 from the original vector $x thus 
yielding a vector of prime numbers between 2 and 100:

    print $x->select(!($x = iota(199) + 2)->in($x |$f| $x));


%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
