%define module_version 0.05
%define module_name Array-Each-Override
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt6
Summary: `each' for iterating over an array's keys and values
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AR/ARC/%{module_name}-%{module_version}.tar.gz
BuildRequires: perl(Array/Each.pm)

%description
This module provides new implementations of three core functions: `each',
`values', and `keys'.

=over 4

=item `each'

The core `each' function iterates over a hash; each time it's called, it
returns a 2-element list of a key and value in the hash.  The new version of
`each' does not change the behaviour of `each' when called on a hash.
However, it also allows you to call `each' on array.  Each time it's called,
it returns a 2-element list of the next uniterated index in the the array, and
the value at that index.

When the array is entirely iterated, an empty list is returned in list context.
The next call to array `each' after that will start iterating again.

=item `keys'

The core `keys' function returns a list of the keys in a hash, or a count of
the keys in a hash when called in scalar context.  The new version of `keys'
does not change the behaviour of `keys' when called on a hash.  However, it
also allows you to call `keys' on an array.

In list context, `keys @array' returns a list of the indexes in the array; in
scalar context, it returns the number of elements in the array.

=item `values'

The core `values' function returns a list of the values in a hash, or a count
of the values in a hash when called in scalar context.  The new version of
`values' does not change the behaviour of `values' when called on a hash.
However, it also allows you to call `values' on an array.

In list context, `values @array' returns a list of the elements in the array;
in scalar context, it returns the number of elements in the array.

=back

There is a single iterator for each array, shared by all `each', `keys', and
`values' calls in the program.  It can be reset by reading all the elements
from the iterator with `each', or by evaluating `keys @array' or `values
@array'.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install
rm -f %buildroot%perl_vendor_archlib/Array/Each/benchmark.pl

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
