# BEGIN SourceDeps(oneline):
BuildRequires: perl(Array/Transpose.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Array-Transpose-Ragged
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Transpose a ragged array
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/Z/ZA/ZARQUON/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Array::Transpose is a handy module to transpose a regular matrix.  However,
using it with an irregular matrix will result in data loss.  This module
transposes a ragged matrix.  Note that it will not preserve values which are
`undef'.


    use warnings; use strict;
    use Array::Transpose::Ragged qw/transpose_ragged/;

    my @array = (
      [qw /00 01/],
      [qw /10 11 12/],
      [qw /20 21/],
      [qw /30 31 32 33 34/],
    );

    my @transpose = transpose_ragged(\@array);

The variable @transpose will now be:

    @transpose = (['00' ,'10' ,'20' ,'30'],
                  ['01' ,'11' ,'21' ,'31'],
                  [undef,'12' ,undef,'32'],
                  [undef,undef,undef,'33'],
                  [undef,undef,undef,'34']
               );


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
