%define module_name ArrayData
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Role/Tiny.pm) perl(Role/Tiny/With.pm) perl(Role/TinyCommons/Collection/GetItemByPos.pm) perl(Role/TinyCommons/Iterator/Resettable.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.6
Release: alt1
Summary: Specification for ArrayData::*, modules that contains array data
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/ArrayData

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
NOTE: EARLY SPECIFICATION; THINGS WILL STILL CHANGE A LOT.

`ArrayData::*' modules are modules that contain array data. The array can be
accessed via a standard interface (see the ArrayDataRole::Spec::Basic manpage). Some
examples of array data are:

=over

=item * list of country names in English (the ArrayData::CountryNames::EN manpage)

=item * list of Indonesian words from KBBI dictionary (the ArrayData::Words::ID::KBBI manpage)

Also under the WordList::ID::KBBI manpage.

=item * list of CPAN authors' PAUSE ID's (the ArrayData::CPAN::PAUSEIDs manpage)

Also under the WordList::CPAN::PAUSEID manpage.

=back

Why put data in a Perl module, as a Perl distribution? To leverage the Perl/CPAN
toolchain and infrastructure: 1) ease of installation, update, and
uninstallation; 2) allowing dependency expression and version comparison; 3)
ease of packaging further as OS packages, e.g. Debian packages (converted from
Perl distribution); 4) testing by CPAN Testers.

The table data can actually be stored as CSV in the DATA section of a Perl
module, or as a CSV file in a shared directory of a Perl distribution, or a Perl
structure in the module source code, or from other sources.

To get started, see the ArrayDataRole::Spec::Basic manpage and one of existing
`ArrayData::*' modules.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/A*

%changelog
