# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Benchmark.pm) perl(CPAN.pm) perl(Carp/Heavy.pm) perl(Class/XSAccessor.pm) perl(Class/XSAccessor/Array.pm) perl(Config.pm) perl(Cwd.pm) perl(Exporter.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Scalar/Util.pm) perl(Socket.pm) perl(YAML/Tiny.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Aspect
%define upstream_version 1.04

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_12
Summary:    Observer pattern with events
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Params/Util.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Sub/Uplevel.pm)
BuildRequires: perl(Task/Weaken.pm)
BuildRequires: perl(Test/Exception.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/NoWarnings.pm)
BuildArch:  noarch
Source44: import.info

%description
What is Aspect-Oriented Programming?
    Aspect-Oriented Programming (AOP) is a programming paradigm which aims
    to increase modularity by allowing the separation of "cross-cutting
    "concerns.

    It includes programming methods and tools that support the
    modularization of concerns at the level of the source code, while
    "aspect-oriented software development" refers to a whole engineering
    discipline.

    Aspect-Oriented Programming (AOP) allows you to modularise code for
    issues that would otherwise be spread across many parts of a program
    and be problematic to both implement and maintain.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl -I. Makefile.PL INSTALLDIRS=vendor
%make_build CFLAGS="%{optflags}"

%check
make test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.yml  README examples
%perl_vendor_privlib/*


%changelog
