# BEGIN SourceDeps(oneline):
BuildRequires: perl(Assert/Refute.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Assert-Refute-T-Numeric
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.16
Release: alt1
Summary: Numeric tests for Assert::Refute suite.
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KH/KHEDIN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Somewhere in your unit-test:

    use Test::More;
    use Assert::Refute::T::Numeric; # must come *after* Test::More

    is_between 4 * atan2( 1, 1 ), 3.1415, 3.1416, "Pi number as expected";

    within_delta sqrt(sqrt(sqrt(10)))**8, 10, 1e-9, "floating point round-trip";

    within_relative 2**20, 1_000_000, 0.1, "10%% precision for 1 mbyte";

    done_testing;

Same for production code:

    use Assert::Refute;
    use Assert::Refute::T::Numeric;

    my $rotate = My::Rotation::Matrix->new( ... );
    try_refute {
        within_delta $rotate->determinant, 1, 1e-6, "Rotation keeps distance";
    };

    my $total = calculate_price();
    try_refute {
        is_between $total, 1, 100, "Price within reasonable limits";
    };

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
