%def_without test
%define module_name Astro-App-Satpass2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Astro/Coord/ECI.pm) perl(Astro/Coord/ECI/Moon.pm) perl(Astro/Coord/ECI/Star.pm) perl(Astro/Coord/ECI/Sun.pm) perl(Astro/Coord/ECI/TLE.pm) perl(Astro/Coord/ECI/TLE/Iridium.pm) perl(Astro/Coord/ECI/TLE/Set.pm) perl(Astro/Coord/ECI/Utils.pm) perl(Attribute/Handlers.pm) perl(Browser/Open.pm) perl(CPAN/Meta.pm) perl(Carp.pm) perl(Clone.pm) perl(Cwd.pm) perl(Date/Manip.pm) perl(Date/Manip/DM5.pm) perl(Date/Manip/TZ.pm) perl(DateTime.pm) perl(DateTime/TimeZone.pm) perl(Exporter.pm) perl(File/Glob.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Geo/Coder/OSM.pm) perl(Getopt/Long.pm) perl(I18N/LangTags.pm) perl(I18N/LangTags/Detect.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/System/Simple.pm) perl(LWP/UserAgent.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Metadata.pm)
BuildRequires: perl(POSIX.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Template.pm) perl(Template/Provider.pm) perl(Test/MockTime.pm) perl(Test2/Plugin/BailOnFail.pm) perl(Test2/Tools/Explain.pm) perl(Test2/Tools/LoadModule.pm) perl(Test2/V0.pm) perl(Text/Abbrev.pm) perl(Text/ParseWords.pm) perl(Text/Wrap.pm) perl(Time/Local.pm) perl(YAML.pm) perl(constant.pm) perl(lib.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.057
Release: alt1
Summary: Predict satellite visibility using Astro::Coord::ECI
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Astro::App::Satpass2;
 # Instantiate and set our location
 my $satpass2 = Astro::App::Satpass2->new(
     location => '1600 Pennsylvania Ave, Washington DC',
     latitude => 38.898748,    # degrees
     longitude => -77.037684,  # degrees
     height => 16.68,          # meters
 );
 # Acquire ISS data from NASA
 $satpass2->spacetrack( qw{ spaceflight -all } );
 # Display our location
 $satpass2->location();
 # Display visible ISS passes over our location
 $satpass2->pass();

Or equivalently, from the satpass2 script which is installed with
this package,

 $ satpass2
          ... front matter displayed here ...
 satpass2> # set our location
 satpass2> set location '1600 Pennsylvania Ave, Washington DC'
 satpass2> set latitude 38.898748 longitude -77.037684
 satpass2> set height 16.68
 satpass2> # Acquire ISS data from NASA
 satpass2> spacetrack spaceflight -all
 satpass2> # Display our location
 satpass2> location
 satpass2> # Display visible ISS passes over our location
 satpass2> pass
 satpass2> # Guess what
 satpass2> exit

The script is implemented in terms of the run() method. Blank
lines and comments are ignored. The first token in the line is the
method name, and subsequent tokens are arguments to that method. See
run() for the details of that method, and the TOKENIZING entry elsewhere in this document for
details of the tokenizer. Finally, see initfile() for where
to put your initialization file, which is just a script that gets
executed every time you invoke the run() method.

If you want to be interactive, simply

 use Astro::App::Satpass2;
 Astro::App::Satpass2->run(@ARGV);

which is essentially the content of the satpass2 script.  In this
last case, the user will be prompted for commands once the commands in
@ARGV are used up, unless those commands include 'exit'.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING Changes README
%perl_vendor_privlib/A*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
