%define module_name Astro-Coord-ECI-TLE-Iridium
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Astro/Coord/ECI.pm) perl(Astro/Coord/ECI/TLE.pm) perl(Astro/Coord/ECI/Utils.pm) perl(CPAN/Meta.pm) perl(Carp.pm) perl(Exporter.pm) perl(FileHandle.pm) perl(Getopt/Std.pm) perl(Module/Build.pm) perl(Module/Metadata.pm) perl(POSIX.pm) perl(Safe.pm) perl(Test/More.pm) perl(Time/Local.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.132
Release: alt1
Summary: Class to compute Iridium Classic flares
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WY/WYANT/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class is a subclass of
Astro::Coord::ECI::TLE, representing
original-design Iridium satellites. This class will probably not work
for the Iridium Next satellites, which are being launched starting early
2017.

The `Astro::Coord::ECI::TLE->parse()' method makes use of
built-in data to determine which satellites to rebless into this class,
based on the object's NORAD SATCAT ID. This internal data can be
modified using the Astro::Coord::ECI::TLE->status method to correct
errors or for historical research. It is also possible to get an Iridium
object by calling $tle->rebless (iridium => {status => $status})
directly.

What this subclass adds is the ability to generate information on
Iridium flares (or glints, as they are also called). Members of this
class are considered capable of generating flares based on their status,
as follows:

 0 => in service
 1 => spare (may or may not flare)
 2 => failed - no predictable flares.

CelesTrak-style statuses ('+', 'S', and '-' respectively) are accepted
on input. See Astro::SpaceTrack method
iridium_status for a way to get current Iridium constellation status.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING README Changes README.MacOS
%perl_vendor_privlib/A*

%changelog
