%define module_name Astro-FITS-CFITSIO-FileName
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dump.pm) perl(Exporter/Shiny.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build/Tiny.pm) perl(Moo.pm) perl(MooX/Tag/TO_HASH.pm) perl(Ref/Util.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test2/V0.pm) perl(Text/Balanced.pm) perl(Type/Library.pm) perl(Type/Tiny/Class.pm) perl(Types/Common/Numeric.pm) perl(Types/Standard.pm) perl(experimental.pm) perl(namespace/clean.pm) perl(overload.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: parse and generate CFITSIO extended file names.
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DJ/DJERIUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CFITSIO packs a lot of functionality into a filename; it can include
row and column filtering, binning and histogramming, image slicing,
etc.  It can be handy to manipulate the various parts that make up
a fully specified CFITSIO filename.

Astro::FITS::CFITSIO::FileName slices and dices a CFITSIO
extended filename into its constituent pieces.  Or, given the constituent
pieces, it can craft an extended CFITSIO filename.

Documentation for the CFITSIO extended filename syntax is available in Chapter 10 of

  https://heasarc.gsfc.nasa.gov/docs/software/fitsio/c/c_user/cfitsio.html

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README CONTRIBUTING.md
%perl_vendor_privlib/A*

%changelog
