# BEGIN SourceDeps(oneline):
BuildRequires: perl(AnyEvent.pm) perl(AnyEvent/HTTP.pm) perl(AnyEvent/Loop.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name Async-Chain
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: The right way to convert nested callback in plain struct
Group: Development/Perl
License: gpl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/R/RE/REZNIKOV/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Every subroutine in the chain receive callable object as first argument followed
by arguments of object call. You can break chain in every sub, just do not call
`$next'.

You can skip some subroutins using `skip' or `jump' method.

    use Async::Chain;

    # with chain call

    chain
        sub {
            my next = shift;
            AnyEvent::HTTP::http_get('http://perldoc.perl.org/', $next);
        },
        sub {
            my next = shift;
            return $next->jump('log')->(0, "not a 200 response");
            ...
            $db->async_insert(..., cb => $next);
        },
        sub {
            my next = shift;
            ...
            $next->($status, $message);
        },
        log => sub {
            my next = shift;
            my ($status, $message) = @_;
            ...
            log(...);
        };
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
