# BEGIN SourceDeps(oneline):
BuildRequires: perl(Digest.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MPEG/Audio/Frame.pm) perl(Test/More.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.1
%define module_name Audio-Digest-MP3
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1
Release: alt1
Summary: Get a message digest for the audio stream out of an MP3 file (skipping ID3 tags)
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/B/BA/BARTL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Sometimes you want to know if you have duplicate MP3 files on your disks. But
as soon as you start editing the ID3 tags, the file contents changes, and you
can no longer trust a plain MD5 checksum on the file, nor the file size, to
compare them.

This module scans the MP3 file, only including the audio stream (undecoded!) to
calculate the message digest.

While it scans, it compiles more metadata about the file, such as playing time,
either in seconds or as formatted string, bitrate (in kbits/sec), stream size
in bytes, and whether the file is a CBR or a VBR file.

In short: lots of info that you can use to compare MP3 files, but excluding any
info coming out of the ID3 tags.

By default, it uses Digest::MD5 to calculate the digest, but if you specify
'SHA1' (or any other specifier for a message digest module, that is compatible
with the Digest manpage) it'll use that instead.

It uses MPEG::Audio::Frame, a Pure Perl module, to extract
the stream from the file. Average processing speed on my computer is about 1-2MB/sec.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/A*

%changelog
