%define module_version 2.03
%define module_name Audio-FindChunks
BuildRequires: unzip
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel perl(Data/Flow.pm) perl(DynaLoader.pm) perl(ExtUtils/MakeMaker.pm) perl(MP3/Splitter.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.03
Release: alt6
Summary: breaks audio files into sound/silence parts.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/I/IL/ILYAZ/modules/%{module_name}-%{module_version}.zip

%description
Audio sequence is broken into parts which contain only noise ("gaps"),
and parts with usable signal ("tracks").

The following configuration settings (and defaults) are supported:

  # For getting PCM flow (and if averaging data is read from cache)
    frequency => 44100,__# If 'raw_pcm' or 'override_header_info' only
    bytes_per_sample => 4,_# likewise
    channels => 2,__# likewise
    sizedata => MY_INF,__# likewise (how many bytes of PCM to read)
    out_fh => \*STDOUT,__# mirror WAV/PCM to this FH if 'filter'
  # Process non-WAV data:
    preprocess => {mp3 => [[qw(lame --silent --decode)], [], ['-']]}, # Second contains extra args to read stdin
  # RMS cache (used if 'valid_rms')
    rms_extension => '.rms',_# Appended to the 'filestem'
  # Averaging to RMS info
    sec_per_chunk => 0.1,_# The window for taking mean square
  # thresholds picking from the list of sorted 3-medians of RMS data
    threshold_in_sorted_min_rel => 0,_ # relative position of 'threashold_min' 
    threshold_in_sorted_min_sec => 1,_ # shifted by this amount in the list
    threshold_factor_min => 1,__ # the list elt is multiplied by this
    threshold_in_sorted_max_rel => 0.5,  # likewise
    threshold_in_sorted_max_sec => 0,_ # likewise
    threshold_factor_max => 1,  _ # likewise
    threshold_ratio => 0.15,__ # relative position between min/max
  # Chunkification: smoothification
    above_thres_window => 11,__ # in units of chunks
    above_thres_window_rel => 0.25, _ # fractions of chunks above threshold
_____ # in a window to make chunk signal
  # Splitting into runs of signal/noise
    max_tracks => 9999,___ # fail if more signal/noise runs
    min_signal_sec => 5,__ # such runs of signal are forced
    min_silence_sec => 2,__ # likewise
    ignore_signal_sec => 1,__ # short runs of signal are ignored
    min_silence_chunks_merge (see below) # and long resulting runs of silence
_____ # are forced
  # Calculate average signal in an interval "deeply inside" silence runs
    local_level_ignore_pre_sec => 0.3,_ # offset the start of this interval
    local_level_ignore_pre_rel => 0.02,  # additional relative offset
    local_level_ignore_post_sec => 0.3,  # likewise for end of the interval
    local_level_ignore_post_rel => 0.02, # likewise
  # Enlargement of signal runs: attach consequent chunks with signal this much
  # above this average over the neighbour silence run
    local_threshold_factor => 1.05,
  # Final enlargement of runs of signal
    extend_track_end_sec => 0.5,_ # Unconditional enlargement
    extend_track_begin_sec => 0.3,_ # likewise
    min_boundary_silence_sec => 0.2,_ # Ignore short silence at start/end

Note that `above_thres_window' is the only value specified directly in
units of chunks; the other `*_sec' may be optionally specified in units
of chunks by setting the corresponding `*_chunks' value.  Note also that
this window should better be decreased if minimal allowed silence length
parameters are decreased.

These values are mirrored from other values if not explicitly specified:

 min_actual_silence_sec << min_silence_sec__# Ignore short gaps
 min_start_silence_sec  << min_boundary_silence_sec_# Same at start
 min_end_silence_sec    << min_boundary_silence_sec_# Same at end
 min_silence_chunks_merge << min_silence_chunks__# See above

 cache_rms_write <<< cache_rms_  # Boolean: write RMS cache
 cache_rms_read  <<< cache_rms_  # Boolean: read RMS cache (unless 'filter')

The following values default to `undef':

    filename___# if undef, read data from STDIN
    stem_strip_extension_# Boolean: 'filestem' has no extension
    filter___# If true, PCM data is mirrored to out_fh
    rms_filename__# Specify cache file explicitly
    raw_pcm___# The input has no WAV header
    override_header_info_# The user specified values override WAV header
    cache_rms___# Use cache file (see *_write, *_read above)
    skip_medians__# Boolean: do not calculate 3-medians
    subchunk_size__# Optimization of calculation of RMS; the
____# best value depends on the processor cache


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
