%define module_name Audit-DBI
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Class/Load.pm) perl(Config/Tiny.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dumper.pm) perl(Data/Validate/Type.pm) perl(MIME/Base64.pm) perl(Module/Build.pm) perl(Storable.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm) perl(Try/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.9.0
Release: alt1
Summary: Audit data changes in your code and store searchable log records in a database.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Audit-DBI

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
use Audit::DBI;

_# Create the audit object.
_my $audit = Audit::DBI->new(
__database_handle => $dbh,
_);

_# Create the necessary tables.
_$audit->create_tables();

_# Record an audit event.
_$audit->record(
__event               => $event,
__subject_type        => $subject_type,
__subject_id          => $subject_id,
__event_time          => $event_time,
__diff                => [ $old_structure, $new_structure ],
__search_data         => \%%search_data,
__information         => \%%information,
__affected_account_id => $account_id,
__file                => $file,
__line                => $line,
_);

_# Search audit events.
_my $audit_events = $audit->review(
__[ search criteria ]
_);

To see an example of a search interface for audit events recorded by
the Audit::DBI manpage, check the `examples/' directory of the Audit::DBI::TT2 manpage.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE ignore.txt Changes README.md example
%perl_vendor_privlib/A*

%changelog
