%define module_name Audit-DBI-TT2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Audit/DBI.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Dump.pm) perl(HTML/Entities.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Scalar/Util.pm) perl(Template/Plugin.pm) perl(Template/Stash.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.3.0
Release: alt1
Summary: A Template Toolkit plugin to display audit events recorded by Audit::DBI
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Audit-DBI-TT2

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
In your Perl code:

_use Audit::DBI::TT2;
_use Template;

_my $template = Template->new(
__{
___PLUGINS =>
___{
____audit => 'Audit::DBI::TT2',
___},
__}
_) || die $Template::ERROR;

In your TT2 template:

_[%% USE audit %%]
_[%% FOREACH result IN audit.format_results( results ) %%]
__...
_[%% END %%]

Note: a fully operational example of a search interface for Audit::DBI events
using this module for the display of the results is available in the
`examples/' directory of this distribution.



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README.md Changes ignore.txt examples
%perl_vendor_privlib/A*

%changelog
