Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(JSON.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Authen-CAS-Client
Version:        0.07
Release:        alt2_22
Summary:        Interface for authentication via JA-SIG's Central Authentication Service
License:        MIT
URL:            https://metacpan.org/release/Authen-CAS-Client
Source0:        https://cpan.metacpan.org/authors/id/P/PR/PRAVUS/Authen-CAS-Client-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/AutoInstall.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl
BuildRequires:  perl(base.pm)
BuildRequires:  perl(LWP/UserAgent.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/QueryParam.pm)
BuildRequires:  perl(XML/LibXML.pm)
# Tests:
BuildRequires:  perl(HTTP/Response.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Test/MockObject.pm)
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
The Authen::CAS::Client module provides a simple interface for
authenticating users using JA-SIG's CAS protocol. Both CAS v1.0 and v2.0
are supported.

%prep
%setup -q -n Authen-CAS-Client-%{version}
# Remove bundled modules
rm -rf inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
# --skipdeps causes ExtUtils::AutoInstall not to try auto-installing
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 --skipdeps
%make_build

%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
