# BEGIN SourceDeps(oneline):
BuildRequires: libcom_err-devel libkrb5-devel perl(DynaLoader.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.03
%define module_name Authen-Krb5Password
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.03
Release: alt6
Summary: Perl extension for Kerberos 5 password verification
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/S/SH/SHUQUE/%{module_name}-%{module_version}.tar.gz

%description
This module provides a Perl function to perform password verification
using Kerberos 5. It is intended for use by applications that cannot
use the Kerberos protocol directly. If it must be run on a system that 
receives a username and password over the network, steps should be 
taken to ensure that these are passed to the server in a cryptographically
secure manner.

kpass() attempts to obtain credentials for the given username and password
from the Kerberos AS, then obtain credentials for a local service from the
Kerberos TGS to verify the authenticity of the AS response. Empty strings 
can be passed as the 3rd and/or 4th arguments to use the default service 
name ("host") and the fully canonicalized primary hostname of the system 
that the function is executed on. The fifth argument may be omitted to use 
the system's default keytab file.

kpass() returns -1 if an error occurs, 0 if the username or password is
incorrect, or 1 if password verification is successful. Errors and
authentication failures are recorded via syslog(3). Because of deficiencies
in Perl's syslog implementation in Sys::Syslog(3), there's no clean way
to log output to any facility other than the default LOG_USER. One
possible way around this problem is to use the Unix::Syslog module
available on CPAN, which correctly uses your platform's native syslog
library routines to perform the functions.
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
