Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Test/CPAN/Changes.pm) perl(Test/Code/TidyAll.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Authen-OATH
Version:        2.0.1
Release:        alt2_26
Summary:        OATH One Time Passwords
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Authen-OATH
Source0:        https://cpan.metacpan.org/authors/id/O/OA/OALDERS/Authen-OATH-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(Digest/HMAC.pm)
BuildRequires:  perl(Math/BigInt.pm)
BuildRequires:  perl(Moo.pm)
BuildRequires:  perl(Types/Standard.pm)
# Tests only:
BuildRequires:  perl(Digest/SHA.pm)
# Pod::Coverage::TrustPod not used
# Pod::Wordlist not used
# Test::CPAN::Changes not used
# Test::Code::TidyAll 0.24 not used
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Needs.pm)
# Test::Spelling not used
# Test::Synopsis not used
# Optional tests:
BuildRequires:  perl(bignum.pm)
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
# Default digest algorithm, also SHA1 is needed by HOTP specification.
Requires:       perl(Digest/SHA.pm)
Source44: import.info

%description
Implementation of the HOTP and TOTP One Time Password algorithms as defined by
OATH (http://www.openauthentication.org).

%prep
%setup -q -n Authen-OATH-%{version}
for F in Changes; do
    sed -e 's/\r//' <"$F" >"${F}.unix"
    touch -r "$F" "${F}.unix"
    mv "${F}.unix" "$F"
done

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes CONTRIBUTORS README.md
%{perl_vendor_privlib}/*

%changelog
