# BEGIN SourceDeps(oneline):
BuildRequires: libsowing-devel libssl-devel perl(Authen/Passphrase.pm) perl(Data/Entropy/Algorithms.pm) perl(Digest/SHA.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(MIME/Base64.pm) perl(Object/Tiny.pm) perl(Test/Exception.pm) perl(XSLoader.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define module_name Authen-Passphrase-Scrypt
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt4
Summary: passphrases using Tarsnap's scrypt algorithm
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MG/MGV/%{module_name}-%{version}.tar.gz

%description
This is experimental code, DO NOT USE in security-critical software.

Scrypt is a key derivation function that was originally developed for
use in the Tarsnap online backup system and is designed to be far more
secure against hardware brute-force attacks than alternative functions
such as PBKDF2 or bcrypt.

Authen::Passphrase::Scrypt is a module for hashing and verifying
passphrases using scrypt. It offers the same interface as
the Authen::Passphrase manpage. It is not however possible to use this module
from within the Authen::Passphrase manpage. The methods are:

=over

=item Authen::Passphrase::Scrypt->new(*%%args*)

Creates a new the Authen::Passphrase::Scrypt manpage from a given passphrase
and parameters. Use this to hash a passphrase. This function takes
either a key value list or a hashref. The arguments are:

=over

=item passphrase

The passphrase. Mandatory.

=item logN

The general work factor (affects both CPU and memory cost). Defaults to 14

=item r

The blocksize (affects memory cost). Defaults to 16.

=item p

The parallelization factor (affects CPU cost). Defaults to 1.

=item salt

A 32-byte string used as a salt. By default it is randomly generated
using the Data::Entropy manpage.

=back

All of the parameters change the result of the hash. They are all
stored in the hash, so there is no need to store them separately (or
provide them to the hash verification methods).

It is normally sufficient to only use the logN parameter to control
the speed of scrypt. r and p are intended to be used only for
fine-tuning: if scrypt uses too much memory but not enough CPU,
decrease logN and increase p; if scrypt uses too much CPU but not
enough memory, decrease logN and increase r.

Note that `2^logN' must fit in 64 bits and `r * p < 2^30'.

=item $sc->as_rfc2307

Returns the hash of the passphrase, in RFC2307 format. This is
"{SCRYPT}" followed by the base64-encoded 96-byte result described here: https://security.stackexchange.com/questions/88678/why-does-node-js-scrypt-function-use-hmac-this-way/91...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/A*
%perl_vendor_autolib/*

%changelog
