%define module_name Autoload-AUTOCAN
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(Scalar/Util.pm) perl(Sub/Util.pm) perl(Test/More.pm) perl(Test/Warnings.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.005
Release: alt1
Summary: Easily set up autoloading
Group: Development/Perl
License: artistic_2
URL: https://github.com/Grinnz/Autoload-AUTOCAN

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBOOK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Autoloading is a very powerful mechanism for
dynamically handling function calls that are not defined. However, its
implementation is very complicated. For the simple case where you wish to
allow method calls to methods that don't yet exist, this module allows you to
define an `AUTOCAN' method which will return either a code reference or
`undef'.

the Autoload::AUTOCAN manpage installs an `AUTOLOAD' subroutine in the current package,
which is invoked when an unknown method is called. The installed `AUTOLOAD'
will call `AUTOCAN' with the invocant (class or object the method was called
on) and the method name. If `AUTOCAN' returns a code reference, it will be
called with the same arguments as passed to the unknown method (including the
invocant). If `AUTOCAN' returns `undef', an error will be thrown as expected
when calling an undefined method.

Along with `AUTOLOAD', the module installs a `can' method which returns code
references as normal for defined methods (see the UNIVERSAL manpage), and delegates to
`AUTOCAN' for unknown methods.

`AUTOLOAD' affects standard function calls in addition to method calls. By
default, the `AUTOLOAD' provided by this module will die (as Perl normally
does without a defined `AUTOLOAD') if a nonexistent function is called without
a class or object invocant. If you wish to autoload functions instead of
methods, you can pass `functions' as an import argument, and the installed
`AUTOLOAD' will autoload functions using `AUTOCAN' from the current package,
rather than using the first argument as an invocant.

  package My::Functions;
  use Autoload::AUTOCAN 'functions';
  
  sub AUTOCAN {
    my ($package, $function) = @_;
    return sub { $_[0]x5 } if $function =~ m/dup/;
    return undef;
  }
  
  # elsewhere
  say My::Functions::duplicate('foo'); # foofoofoofoofoo
  say My::Functions::foo('bar'); # undefined subroutine error
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CONTRIBUTING.md LICENSE README Changes
%perl_vendor_privlib/A*

%changelog
