Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(DBI.pm) perl(DBIx/Class/Schema/Loader.pm) perl(File/Find/Rule.pm) perl(IO/Zlib.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-BackPAN-Index
Version:        0.42
Release:        alt2_29
Summary:        Interface to the BackPAN index
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/BackPAN-Index
Source0:        https://cpan.metacpan.org/authors/id/M/MS/MSCHWERN/BackPAN-Index-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(App/Cache.pm)
BuildRequires:  perl(Archive/Extract.pm)
BuildRequires:  perl(autodie.pm)
BuildRequires:  perl(CLASS.pm)
BuildRequires:  perl(CPAN/DistnameInfo.pm)
BuildRequires:  perl(DBD/SQLite.pm)
BuildRequires:  perl(DBIx/Class.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Spec/Unix.pm)
BuildRequires:  perl(LWP/Simple.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Mouse.pm)
BuildRequires:  perl(parent.pm)
BuildRequires:  perl(Path/Class.pm)
BuildRequires:  perl(Test/Compile.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(URI.pm)
Requires:       perl(CLASS.pm) >= 1.0
Requires:       perl(DBD/SQLite.pm) >= 1.250
Requires:       perl(DBIx/Class.pm) >= 0.081.090
Requires:       perl(Path/Class.pm) >= 0.170

# Parse::BACKPAN::Packages is deprecated in favor of BackPAN::Index
Obsoletes:      perl-Parse-BACKPAN-Packages <= 0.35

%{echo 
%filter_from_requires /perl.CLASS.pm.$/d;/perl.Path.Class.pm.$/d

}

Source44: import.info

%description
This downloads, caches and parses the BackPAN index into a local database
for efficient querying.

%prep
%setup -q -n BackPAN-Index-%{version}

sed -i -e '1s~^#!.*perl~#!%{__perl}~' examples/backpan.pl

%build
/usr/bin/perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=%{buildroot} create_packlist=0
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null \;

# %{_fixperms} %{buildroot}/*

%check
BACKPAN_INDEX_TEST_NO_INTERNET=1 ./Build test

%files
%doc CHANGES examples LICENSE README
%{perl_vendor_privlib}/*

%changelog
