# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(FindBin.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define module_version 0.05
%define module_name BaseLib
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.05
Release: alt1
Summary: manipulate @INC dynamically for independent installation path
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/H/HA/HASANT/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
If you have a set of application with certain file structure under a
base directory, e.g. `pim', and it has a private modules directory
called `lib-perl', and it's intalled under `/usr/local'. For the
application to work, the scripts may need to say:

   use lib '/usr/local/pim/lib-perl';

Someday, you need to move the application to, say, `/vhost/www.host.com',
so you need to change the use statement all over the scripts to:

   use lib '/vhost/www.some.host.com/pim/lib-perl';

If you do this a lot and get tired of changing the line for every
different installation path in every script, or, you don't want to
bother people using your application to change the line to meet their
conditions, then you might need this module.

Now your scripts can say:

   use BaseLib qw(pim lib-perl);

where `pim' and `lib-perl' are the BASEDIR and LIBDIR arguments,
respectively.

So there's no need to worry about different installation layout, wherever
the `pim' base directory is put under. The BASEDIR argument is mandatory
while LIBDIR is optional (defaults to `lib/perl').

As addition, you can use BaseLib's global package variable,
$BaseDir to refer to the full path to `pim'. For example,
assuming the application is installed under `/usr/local', then

   print "Data dir: $BaseLib::BaseDir/data\n";

will print,

   Data dir: /usr/local/pim/data

You have to use the fully qualified package name since it's not
exportable.

You can use your own global variable by supplying the third argument
in the use statement. For example,

   use BaseLib qw(pim lib-perl MyOwnBaseDir);

So saying,

   print "Data dir: $MyOwnBaseDir/data\n";

will result the same thing. If you use 'use strict;', which is a good
thing, you need to explicitly declare it as global variable. Either,

   use vars '$MyOwnBaseDir';

or, if you use version 5.6 or later,

   our $MyOwnBaseDir;

If you want to use the default LIBDIR (`lib/perl'), you can indicate
so by using dash ("-").

   use BaseLib qw(pim - MyOwnBaseDir);

Or, just give an empty string,

   use BaseLib ('pim', '', 'MyOwnBaseDir');



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes docs
%perl_vendor_privlib/B*

%changelog
