# BEGIN SourceDeps(oneline):
BuildRequires: perl(Chart/Gnuplot.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Smart/Args.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.01
%define module_name Benchmark-Chart
BuildRequires: unzip
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: Plots your L<Benchmark>
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DO/DOHNTO/%{module_name}-%{module_version}.zip
BuildArch: noarch

%description
Benchmark::Chart plots your Benchmark(s) using Gnuplot.
If you are not familiar with module the Benchmark manpage, please study that first.

Common usage:

    use Benchmark qw/:all/;
    use Benchmark::Chart qw/plotthese/;
    
    sub createSubs {
        my $x = shift;
        return {
            'x * x' => sub { $x * $x },
            'x ^ 2' => sub { $x**2 },
        };
    }
    
    # functional interface
    my $result = timethese( 20000000, createSubs( 9467443 ), 'none' );
    plotthese(
        options => {
            title  => "My cool benchmark",
            output => "benchmark1.png",
        },
        data => $result
    );
    
    # or if you have more data
    my %%inputs = (
        '9999999'               => 9999999,
        '88888888888'           => 88888888888,
        '777777777777777777777' => 777777777777777777777,
    );
    
    my @results;
    for my $k ( keys %%inputs ) {
        push @results, { $k => timethese( 20000000, createSubs( $inputs{$k} ), 'none' ) };
    }
    
    plotthese(
        options => {
            title  => "My cool benchmark",
            output => "benchmark2.png",
        },
        data => \@results
    );
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes
%perl_vendor_privlib/B*

%changelog
