%def_without test
%define module_name Benchmark-Thread-Size
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Devel/Required.pm) perl(ExtUtils/MakeMaker.pm) perl(threads.pm) perl(threads/shared.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.10
Release: alt1
Summary: report size of threads for different code approaches
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LN/LNATION/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
*** A note of CAUTION ***

 This module only functions on Perl versions 5.8.0 and later.
 And then only when threads are enabled with -Dusethreads.  It
 is of no use with any version of Perl before 5.8.0 or without
 threads enabled.

                  *************************

The Benchmark::Thread::Size module reports how much memory is used by different
pieces of source code within a threaded application.  This allows you to test
different approaches to coding a specific threaded application or to find ways
how to reduce memory usage of threads in general.

It achieves this goal by running the indicated code with a varying number of
threads and asking the operating system how much memory is in use.  This is
an empirical process that may take quite some time on slower machines.

One or more approaches can be checked at a time, each tested 10 times by
default.  Each approach is compared to an empty piece of code (the reference)
to allow you to easily determine how much memory each different approach has
taken.  Testing is done for 0, 1, 2, 5, 10, 20, 50 and 100 threads.  The code
you specify is only entered once in the main thread and consequently cloned
to all threads when they are created (which is where it becomes very
important to reduce as much as possible.

The final report is sent to STDOUT.  This is an example report:

   #   (ref)        bare        full        vars         our      unique
   0    2172          +0          +0          +0          +0          +0    
   1    2624 N 4      +4 N 4      +4 N 4     +27          +4 N 4     +27    
   2    3004 N 4      +2 N 6      +2 N 6     +33 N 4      +8         +36 N 6
   5    4126 N 6      -2 N 6      -3 N 8     +29 N 4     +10 N 2     +27 N 4
  10    5984 N 8      -1 N 8      +0 N 4      +0 N 6     +17 N 4     +43 N 6
  20    9694 N 4     +15 N 4     +15 N 2     +13 N 6     +32 N 6     +58 N 6
  50   20832 N 4     +51 N10     +50 N 8     +50 N 8     +68 N12     +96 N 6
 100   39392 N 8    +106 N10    +156 N12    +108 N10    +131 N10    +155 N12
 ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO CHANGELOG README
%perl_vendor_privlib/B*

%changelog
