%define module_name Bible-Reference
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Portability/Files.pm) perl(Test/Synopsis.pm) perl(Test2/V0.pm) perl(XS/Parse/Keyword.pm) perl(exact.pm) perl(exact/class.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.19
Release: alt1
Summary: Simple Bible reference parser, tester, and canonicalizer
Group: Development/Perl
License: artistic_2
URL: https://github.com/gryphonshafer/Bible-Reference

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GR/GRYPHON/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module is intended to address Bible reference canonicalization. Given some
input, the module will search for Bible references, canonicalize them, and
return them in various forms desired. It can return the canonicalized within
the context of the input string or strings as well.

The module supports the Protestant Bible by default and by configuration
setting also the Orthodox Bible, the current Catholic Bible, and the Vulgate.

There are also some potentially useful helper methods.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes SECURITY.md
%perl_vendor_privlib/B*

%changelog
