# BEGIN SourceDeps(oneline):
BuildRequires: perl(Apache/DBI.pm) perl(Bio/Annotation/Collection.pm) perl(Bio/DB/BioFetch.pm) perl(Bio/DB/Fasta.pm) perl(Bio/DB/GFF/Util/Binning.pm) perl(Bio/DB/GFF/Util/Rearrange.pm) perl(Bio/Das/FeatureTypeI.pm) perl(Bio/Das/SegmentI.pm) perl(Bio/DasI.pm) perl(Bio/Location/Simple.pm) perl(Bio/Location/Split.pm) perl(Bio/LocationI.pm) perl(Bio/PrimarySeq.pm) perl(Bio/RangeI.pm) perl(Bio/Root/Root.pm) perl(Bio/Root/RootI.pm) perl(Bio/Root/Test.pm) perl(Bio/Root/Version.pm) perl(Bio/SeqFeatureI.pm) perl(Bio/SeqI.pm) perl(Bio/SeqIO.pm) perl(CGI.pm) perl(Carp.pm) perl(DBD/Pg.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(DB_File.pm) perl(Data/Dumper.pm) perl(Digest/MD5.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Glob.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm)
BuildRequires: perl(Getopt/Long.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Module/Build.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(overload.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-DB-GFF
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.4
Release: alt1
Summary: Storage and retrieval of sequence annotation data
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-GFF

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Bio::DB::GFF provides fast indexed access to a sequence annotation
database.  It supports multiple database types (ACeDB, relational),
and multiple schemas through a system of adaptors and aggregators.

The following operations are supported by this module:

  - retrieving a segment of sequence based on the ID of a landmark
  - retrieving the DNA from that segment
  - finding all annotations that overlap with the segment
  - finding all annotations that are completely contained within the
    segment
  - retrieving all annotations of a particular type, either within a
    segment, or globally
  - conversion from absolute to relative coordinates and back again,
    using any arbitrary landmark for the relative coordinates
  - using a sequence segment to create new segments based on relative
    offsets

The data model used by Bio::DB::GFF is compatible with the GFF flat
file format (http://www.sequenceontology.org/gff3.shtml). The module
can load a set of GFF files into the database, and serves objects that
have methods corresponding to GFF fields.

The objects returned by Bio::DB::GFF are compatible with the
SeqFeatureI interface, allowing their use by the Bio::Graphics and
Bio::DAS modules.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
