%define module_name Bio-DB-RefSeq
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/DBFetch.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/RequiresInternet.pm) perl(base.pm) perl(strict.pm) perl(utf8.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.4
Release: alt1
Summary: Database object interface for RefSeq retrieval
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-RefSeq

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Allows the dynamic retrieval of sequence objects the Bio::Seq manpage from the
RefSeq nucleotide database using the dbfetch script at EBI:

http://www.ebi.ac.uk/Tools/dbfetch/dbfetch

At this time the module specifically retrieves nucleotide sequences 
only.

In order to make changes transparent we have host type (currently only
ebi) and location (defaults to ebi) separated out.  This allows later
additions of more servers in different geographical locations.

The functionality of this module is inherited from the Bio::DB::DBFetch manpage
which implements the Bio::DB::WebDBSeqI manpage.

This module retrieves entries from EBI although it
retrieves database entries produced at NCBI. When read into bioperl
objects, the parser for GenBank format it used. RefSeq is a
NONSTANDARD GenBank file so be ready for surprises.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%changelog
