%define module_name Bio-DB-SeqFeature
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/Fasta.pm) perl(Bio/DB/GFF/Typename.pm) perl(Bio/DB/GFF/Util/Rearrange.pm) perl(Bio/Location/Simple.pm) perl(Bio/PrimarySeq.pm) perl(Bio/RangeI.pm) perl(Bio/Root/Root.pm) perl(Bio/Root/Test.pm) perl(Bio/Seq.pm) perl(Bio/SeqFeature/CollectionI.pm) perl(Bio/SeqFeature/Lite.pm) perl(Carp.pm) perl(Cwd.pm) perl(DBD/Pg.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(DB_File.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Glob.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Getopt/Long.pm) perl(IO/File.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(MIME/Base64.pm) perl(Memoize.pm) perl(Pod/Usage.pm) perl(Scalar/Util.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Text/ParseWords.pm) perl(base.pm)
BuildRequires: perl(constant.pm) perl(lib.pm) perl(overload.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.5
Release: alt1
Summary: Normalized feature for use with Bio::DB::SeqFeature::Store
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-SeqFeature

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The Bio::DB::SeqFeature object is the default SeqFeature class stored
in Bio::DB::SeqFeature databases. It implements both the
Bio::DB::SeqFeature::NormalizedFeatureI and
Bio::DB::SeqFeature::NormalizedTableFeatureI interfaces, which means that its
subfeatures, if any, are stored in the database in a normalized
fashion, and that the parent/child hierarchy of features and
subfeatures are also stored in the database as set of tuples. This
provides efficiencies in both storage and retrieval speed.

Typically you will not create Bio::DB::SeqFeature directly, but will
ask the database to do so on your behalf, as described in
the Bio::DB::SeqFeature::Store manpage.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
