%define module_name Bio-DB-SwissProt
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/WebDBSeqI.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(HTTP/Request/Common.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/EOL.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/Needs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/RequiresInternet.pm) perl(base.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.4
Release: alt1
Summary: Database object interface to SwissProt retrieval
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-SwissProt

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
SwissProt is a curated database of proteins managed by the Swiss
Bioinformatics Institute. Additional tools for
parsing and manipulating swissprot files can be found at
ftp://ftp.ebi.ac.uk/pub/software/swissprot/Swissknife/.

Allows the dynamic retrieval of Sequence objects (Bio::Seq) from the
SwissProt database via an Expasy retrieval.

In order to make changes transparent we have host type (currently only
expasy) and location (default to Switzerland) separated out.  This
allows the user to pick the closest Expasy mirror for running their
queries.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/B*

%changelog
