# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/DB/Taxonomy.pm) perl(Bio/Root/Test.pm) perl(Bio/Taxon.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(DB_File.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/Spec/Functions.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Test/Mojibake.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Bio-DB-Taxonomy-sqlite
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.7.3
Release: alt1
Summary: SQLite-based implementation of Bio::DB::Taxonomy::flatfile
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Bio-DB-Taxonomy-sqlite

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CJ/CJFIELDS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is an implementation of Bio::DB::Taxonomy which stores and accesses the
NCBI taxonomy using a simple SQLite3 database stored locally on disk.

With this implementation, one can do the same basic searches as with the 'flatfile'
database.  A test lookup of 1000 NCBI TaxIDs with full lineage information took
about 2 seconds on my older MacBook Pro laptop with an on-disk implementation.

A few key differences:

=over 4

=item * You can use typical SQL syntax to run a query search; for instance, if you want you can run:

   @ids = sort $db->get_taxonids('Chloroflexi%%');

=item * In-memory database is allowed

  my $db = Bio::DB::Taxonomy->new(-source    => 'sqlite',
                                  -db        => ':memory:',
                                  -nodesfile => 'nodes.dmp',
                                  -namesfile => 'names.dmp');

=back

The required database files, nodes.dmp and names.dmp can be obtained from
ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE
%perl_vendor_privlib/B*

%changelog
