%define module_version 0.04
%define module_name Bio-MaxQuant-ProteinGroups-Response
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Path.pm) perl(IO/File.pm) perl(Math/SigFigs.pm) perl(Statistics/Reproducibility.pm) perl(Test/More.pm) perl(Text/CSV.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: Analyze MQ proteinGroups for differential responses
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/J/JI/JIMI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is tailored for MaxQuant data, but could be applicable elsewhere.
The target experiment is one where several celltypes have been assayed for 
responses to different conditions, e.g. cancer cell lines responding to 
hormones and drugs.  The module help to analyse responses to the conditions
within each cell line and differences in those responses between cell lines.
Those differences in responses indicate that the proteins involved are markers
of the mechanism by which the cells differ in their response, and are therefore
not only good targets to exploit for biomarkers, but also for biological follow up.

    use Bio::MaxQuant::ProteinGroups::Response;

    my $resp = Bio::MaxQuant::ProteinGroups::Response->new(
    _filepath=>'proteinGroups.txt'
    );

    $resp->replicate_comparison(output_directory=>'./replicate_comparisons');
_$resp->calculate_response_comparisons(output_directory=>'./responses');
_$resp->calculate_differential_response_comparisons(output_directory=>'./differential_responses');

The data are output as tables in the directories.  They are the printable tables
returned from Statistics::Reproducibility.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/B*

%changelog
