%define module_name Bio-Phylo-CIPRES
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Bio/Phylo.pm) perl(ExtUtils/MakeMaker.pm) perl(LWP/UserAgent.pm) perl(Pod/Usage.pm) perl(Test/More.pm) perl(URI.pm) perl(XML/Twig.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: Client for the CIPRES analysis portal
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RV/RVOSA/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
# Bio::CIPRES
Phylogenomic analysis on the CIPRES REST portal

## Prerequisites
Usage of CIPRES requires a [DEVELOPER account](https://www.phylo.org/restusers/register.action) 
(not a normal user account) for the CIPRES REST API (CRA), and a 
[registration](https://www.phylo.org/restusers/createApplication!input.action) for the app 
`corvid19_phylogeny`.With the account and app key, you can then populate a YAML file 
`cipres_appinfo.yml` thusly, substituting the fields with pointy brackets with the 
appropriate values:

```yaml
---

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_privlib/B*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
